package gov.va.med.mhv.usermgmt.bizobj;

import org.apache.commons.lang.StringUtils;
import java.util.List;

/**
 * Business object for the Facility application entity
 *
 * Generated Skeleton Code
 */
 
public class FacilityBO extends FacilityBaseBO {
	
	protected void complexValidation() {
		String stationNumber = this.getName();
		if(!StringUtils.isBlank(stationNumber)){
			List facilities = FacilityInfoBO.queryByStationNumber(stationNumber);
			if(facilities == null || facilities.size() == 0){
				addError("facility.not.found", new String[]{stationNumber});
			}
			else if(facilities.size() > 1){
				addError("facility.multiple.found", new String[]{stationNumber});
			}
			else{
				setFacilityInfo((FacilityInfoBO)facilities.get(0));
			}
		}
		
	}

}